/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.analysis.dpEngine;

import ibm.nways.analysis.dpCommon.HistoryEvent;
import ibm.nways.analysis.dpCommon.NotifyObject;
import ibm.nways.analysis.dpCommon.PerformanceEvent;
import ibm.nways.analysis.dpCommon.PollingObjectDefinition;
import ibm.nways.analysis.dpCommon.PollingObjectInstance;
import ibm.nways.analysis.dpEngine.Backdoor;
import ibm.nways.analysis.dpEngine.BasicScheduler;
import ibm.nways.analysis.dpEngine.CleanUpFiles;
import ibm.nways.analysis.dpEngine.Daily;
import ibm.nways.analysis.dpEngine.DpInterface;
import ibm.nways.analysis.dpEngine.DpNode;
import ibm.nways.analysis.dpEngine.DpPollingDefinition;
import ibm.nways.analysis.dpEngine.DpPollingInstance;
import ibm.nways.analysis.dpEngine.DpeConfig;
import ibm.nways.analysis.dpEngine.DpeCounters;
import ibm.nways.analysis.dpEngine.DpeStats;
import ibm.nways.analysis.dpEngine.IllegalInsertException;
import ibm.nways.analysis.dpEngine.Interval;
import ibm.nways.analysis.dpEngine.Monitor;
import ibm.nways.analysis.dpEngine.NodeList;
import ibm.nways.analysis.dpEngine.NotifyList;
import ibm.nways.analysis.dpEngine.PollerList;
import ibm.nways.analysis.dpEngine.Scheduled;
import ibm.nways.analysis.dpEngine.Weekly;
import ibm.nways.analysis.dpManager.DpmInterface;
import ibm.nways.jdm.snmp.SnmpAPI;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.rmi.Naming;
import java.rmi.RMISecurityManager;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.Date;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.Properties;
import java.util.SimpleTimeZone;
import java.util.TimeZone;
import java.util.Vector;

public class DpInterfaceImpl
extends UnicastRemoteObject
implements Scheduled,
DpInterface,
Runnable {
    public static DpmInterface refServer;
    protected static String serverhostname;
    protected static DpInterfaceImpl interfaceObject;
    private Hashtable pollingDefinitions = new Hashtable();
    protected static NodeList nodeList;
    private static NotifyList nList;
    private static Monitor healthMonitor;
    protected static PollerList pollerList;
    private static Backdoor backdoor;
    public static String dataRoot;
    public static boolean trace;
    public static boolean trace_schedule;
    public static boolean trace_expression;
    public static boolean writeToFile;
    public static int maxConsecutiveFailures;
    public static int historySize;
    public static int internalHistorySize;
    public static float autoThresholdLevel;
    public static int minTimeBetweenSaves;
    public static int maxTimeBetweenSaves;
    public static int validSampleInterval;
    public static float historyThreshold;
    public static int maxNotifyListSize;
    protected static boolean sendHistoryWithEvent;
    protected static boolean useSysUpTime;
    public static int heartbeatTimeout;
    public static String fileBase;
    public static boolean test;
    protected static int intervalsMatched;
    protected static boolean reconnectThreadRunning;
    protected static int timeDelayAfterReconnect;
    protected static int lastNotifiedLevel;
    protected static float minValueVariationPercent;
    private static boolean sendEvents;
    private Object dpeSchedule;
    private BasicScheduler dpeScheduler;
    private int offAction;
    private String dpeHostname;
    private long pollsSent;
    private long variablesSent;
    public static final int REPLACE = 0;
    public static final int ADD = 1;
    public static final int REMOVE = 2;

    public DpInterfaceImpl() throws RemoteException {
        interfaceObject = this;
        String string = null;
        boolean bl = true;
        boolean bl2 = false;
        boolean bl3 = true;
        Properties properties = System.getProperties();
        serverhostname = properties.getProperty("serverHostname");
        String string2 = properties.getProperty("resynch", "true");
        if ("false".equals(string2)) {
            bl = false;
        }
        if ("true".equals(string2 = properties.getProperty("load", "false"))) {
            bl = true;
        }
        if ("false".equals(string2 = properties.getProperty("writeFile", "true"))) {
            bl = false;
        }
        string = properties.getProperty("configDir");
        string2 = properties.getProperty("trace", "false");
        if ("true".equals(string2) || "yes".equals(string2) || "TRUE".equals(string2) || "YES".equals(string2)) {
            trace = true;
        }
        if ("true".equals(string2 = properties.getProperty("traceExpression", "false")) || "yes".equals(string2) || "TRUE".equals(string2) || "YES".equals(string2)) {
            trace_expression = true;
        }
        if ("true".equals(string2 = properties.getProperty("traceSchedule", "false")) || "yes".equals(string2) || "TRUE".equals(string2) || "YES".equals(string2)) {
            trace_schedule = true;
        }
        this.initialize(string, bl, bl2, bl3);
        try {
            refServer = (DpmInterface)Naming.lookup("rmi://" + serverhostname + ":2099/dpServer");
            System.out.println("Bound successfully to the server ...\n");
            UnicastRemoteObject.exportObject(this);
            return;
        }
        catch (Exception exception) {
            System.out.println("lookup of server failed : " + exception);
            refServer = null;
            return;
        }
    }

    public DpInterfaceImpl(String string, String string2, boolean bl, boolean bl2, boolean bl3) throws RemoteException {
        serverhostname = string;
        interfaceObject = this;
        this.initialize(string2, bl, bl2, bl3);
        try {
            refServer = (DpmInterface)Naming.lookup("rmi://" + string + ":2099/dpServer");
            System.out.println("Bound successfully to the server ...\n");
            UnicastRemoteObject.exportObject(this);
            refServer.registerDPEngine(interfaceObject);
            DpInterfaceImpl.sendStatisticsEvent(this.getDpeStats());
            return;
        }
        catch (Exception exception) {
            System.out.println("lookup of server failed : " + exception);
            refServer = null;
            return;
        }
    }

    public DpInterfaceImpl(DpmInterface dpmInterface, String string, boolean bl, boolean bl2, boolean bl3) throws RemoteException {
        interfaceObject = this;
        this.initialize(string, bl, bl2, bl3);
        refServer = dpmInterface;
        DpInterfaceImpl.sendStatisticsEvent(this.getDpeStats());
    }

    private void initialize(String string, boolean bl, boolean bl2, boolean bl3) throws RemoteException {
        if (string != null) {
            if (trace) {
                DpInterfaceImpl.LogMessage("DpInterfaceImpl: non-null config dir: " + string);
            }
            dataRoot = string;
        }
        this.pollsSent = 0L;
        this.variablesSent = 0L;
        try {
            this.dpeHostname = InetAddress.getLocalHost().getHostAddress();
            SnmpAPI.initialize();
        }
        catch (Exception exception) {
            System.out.println("Could not find local host information : " + exception);
        }
        nodeList = new NodeList(bl2);
        writeToFile = bl3;
        nList.start();
        healthMonitor = new Monitor(this);
        healthMonitor.start();
        pollerList = new PollerList(healthMonitor);
        backdoor = new Backdoor(this, 2098);
        backdoor.start();
        if (!bl) {
            CleanUpFiles cleanUpFiles = new CleanUpFiles();
            cleanUpFiles.start();
        }
    }

    public synchronized boolean addPollingObjectDefinitions(Vector vector) throws RemoteException, IllegalInsertException {
        boolean bl = true;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            boolean bl2 = this.addPollingObjectDefinition((PollingObjectDefinition)enumeration.nextElement());
            if (bl2) continue;
            bl = false;
        }
        return bl;
    }

    public synchronized boolean addPollingObjectDefinition(PollingObjectDefinition pollingObjectDefinition) throws RemoteException, IllegalInsertException {
        DpPollingDefinition dpPollingDefinition;
        boolean bl = true;
        if (trace) {
            DpInterfaceImpl.LogMessage("ADDING PollingObjectDefinition : interval=" + pollingObjectDefinition.getNotifyObject().getPollingInterval() + "\n" + pollingObjectDefinition.toString());
        }
        if ((dpPollingDefinition = (DpPollingDefinition)this.pollingDefinitions.get(pollingObjectDefinition.getIdentifier())) == null) {
            DpPollingDefinition dpPollingDefinition2 = new DpPollingDefinition(pollingObjectDefinition);
            this.pollingDefinitions.put(pollingObjectDefinition.getIdentifier(), dpPollingDefinition2);
        } else {
            bl = false;
        }
        return bl;
    }

    public synchronized boolean removePollingObjectDefinition(Vector vector) throws RemoteException {
        if (trace) {
            DpInterfaceImpl.LogMessage("REMOVING PollingObjectDefinition");
        }
        long l = System.currentTimeMillis();
        boolean bl = true;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            DpPollingDefinition dpPollingDefinition = (DpPollingDefinition)this.pollingDefinitions.remove((String)enumeration.nextElement());
            if (dpPollingDefinition == null) {
                bl = false;
                continue;
            }
            dpPollingDefinition.kill();
        }
        if (trace) {
            DpInterfaceImpl.LogMessage("Removal of all pollingDefinitions took " + (System.currentTimeMillis() - l) + " milliseconds.");
        }
        return bl;
    }

    public synchronized boolean addPollingObjectInstances(Vector vector) throws RemoteException {
        return this.addPollingObjectInstances(vector, false);
    }

    public synchronized boolean addPollingObjectInstances(Vector vector, boolean bl) throws RemoteException {
        boolean bl2 = true;
        int n = vector.size();
        if (trace) {
            DpInterfaceImpl.LogMessage("DpInterfaceImpl: adding " + n + " POI");
        }
        if (n > 50) {
            Thread.currentThread().setPriority(1);
        }
        int n2 = 0;
        while (n2 < n) {
            DpPollingDefinition dpPollingDefinition;
            PollingObjectInstance pollingObjectInstance = (PollingObjectInstance)vector.elementAt(n2);
            if (trace) {
                DpInterfaceImpl.LogMessage("DpInterfaceImpl: adding poi:" + pollingObjectInstance.toString());
            }
            if ((dpPollingDefinition = (DpPollingDefinition)this.pollingDefinitions.get(pollingObjectInstance.getIdentifier())) != null) {
                boolean bl3 = true;
                bl3 = dpPollingDefinition.addPollingInstance(pollingObjectInstance.getIndex(), pollingObjectInstance.getHostname(), pollingObjectInstance.getCommunityname(), nodeList, pollingObjectInstance.getKeywords(), bl);
                if (!bl3) {
                    bl2 = false;
                }
            }
            ++n2;
        }
        this.activatePollers();
        if (trace) {
            DpInterfaceImpl.LogMessage("DpInterfaceImpl: completed adding POI");
        }
        return bl2;
    }

    public synchronized boolean removePollingObjectInstances(Vector vector) throws RemoteException {
        boolean bl = true;
        int n = vector.size();
        if (trace) {
            DpInterfaceImpl.LogMessage("DpInterfaceImpl: removing " + n + " POI");
        }
        int n2 = 0;
        while (n2 < n) {
            PollingObjectInstance pollingObjectInstance = (PollingObjectInstance)vector.elementAt(n2);
            DpPollingDefinition dpPollingDefinition = (DpPollingDefinition)this.pollingDefinitions.get(pollingObjectInstance.getIdentifier());
            if (dpPollingDefinition != null) {
                dpPollingDefinition.removePollingInstance(pollingObjectInstance.getHostname(), pollingObjectInstance.getIndex(), nodeList);
                if (!dpPollingDefinition.hasInstances()) {
                    this.pollingDefinitions.remove(pollingObjectInstance.getIdentifier());
                }
            }
            ++n2;
        }
        if (this.pollingDefinitions.isEmpty()) {
            intervalsMatched = 50;
        }
        if (trace) {
            DpInterfaceImpl.LogMessage("DpInterfaceImpl: completed removing " + n + " POI");
        }
        return bl;
    }

    public synchronized boolean modifyPollingObjectDefinition(String string, NotifyObject notifyObject) throws RemoteException {
        DpPollingDefinition dpPollingDefinition = (DpPollingDefinition)this.pollingDefinitions.get(string);
        if (dpPollingDefinition == null) {
            return false;
        }
        return dpPollingDefinition.modifyDefinition(notifyObject);
    }

    public synchronized boolean modifyPollingObjectInstance(PollingObjectInstance pollingObjectInstance, NotifyObject notifyObject) throws RemoteException {
        DpPollingDefinition dpPollingDefinition = (DpPollingDefinition)this.pollingDefinitions.get(pollingObjectInstance.getIdentifier());
        if (dpPollingDefinition == null) {
            return false;
        }
        return dpPollingDefinition.modifySpecificPollingInstance(0, pollingObjectInstance.getHostname(), pollingObjectInstance.getIndex(), notifyObject);
    }

    public synchronized boolean addScheduleToPollingObjectInstance(PollingObjectInstance pollingObjectInstance, Daily daily, int n) throws RemoteException {
        DpPollingDefinition dpPollingDefinition;
        if (trace) {
            DpInterfaceImpl.LogMessage("DpInterfaceImpl: adding scheduling to POI:" + pollingObjectInstance.toString() + ",\n  Daily Schedule=" + daily.toString());
        }
        if ((dpPollingDefinition = (DpPollingDefinition)this.pollingDefinitions.get(pollingObjectInstance.getIdentifier())) == null) {
            return false;
        }
        return dpPollingDefinition.scheduleSpecificPollingInstance(pollingObjectInstance, daily, n);
    }

    public synchronized boolean addScheduleToPollingObjectInstance(PollingObjectInstance pollingObjectInstance, Weekly weekly, int n) throws RemoteException {
        DpPollingDefinition dpPollingDefinition;
        if (trace) {
            DpInterfaceImpl.LogMessage("DpInterfaceImpl: adding scheduling to POI:" + pollingObjectInstance.toString() + ",\n  Weekly Schedule=" + weekly.toString());
        }
        if ((dpPollingDefinition = (DpPollingDefinition)this.pollingDefinitions.get(pollingObjectInstance.getIdentifier())) == null) {
            return false;
        }
        return dpPollingDefinition.scheduleSpecificPollingInstance(pollingObjectInstance, weekly, n);
    }

    public Vector queryPollingObjectDefinitions() throws RemoteException {
        Vector<String> vector = new Vector<String>();
        Enumeration enumeration = this.pollingDefinitions.elements();
        while (enumeration.hasMoreElements()) {
            vector.addElement(((DpPollingDefinition)enumeration.nextElement()).getPollingObjectDefinition().getIdentifier());
        }
        return vector;
    }

    public synchronized Vector getPollingObjectInstance(Vector vector, Vector vector2, long l) throws RemoteException {
        DpPollingDefinition dpPollingDefinition;
        Vector<PollingObjectInstance> vector3 = new Vector<PollingObjectInstance>();
        Vector vector4 = null;
        if (vector == null || vector.size() == 0) {
            if (trace) {
                DpInterfaceImpl.LogMessage("Getting POI with a NULL list of POI");
            }
            return null;
        }
        PollingObjectInstance pollingObjectInstance = (PollingObjectInstance)vector.elementAt(0);
        if (trace) {
            DpInterfaceImpl.LogMessage("Getting POI " + pollingObjectInstance.toString());
        }
        if ((dpPollingDefinition = (DpPollingDefinition)this.pollingDefinitions.get(pollingObjectInstance.getIdentifier())) == null) {
            return null;
        }
        DpPollingInstance dpPollingInstance = dpPollingDefinition.getSpecificPollingInstance(pollingObjectInstance.getHostname(), pollingObjectInstance.getIndex());
        if (dpPollingInstance != null) {
            String string = pollingObjectInstance.getIdentifier();
            String string2 = pollingObjectInstance.getHostname();
            int n = vector.size();
            int n2 = 0;
            while (n2 < n) {
                pollingObjectInstance = (PollingObjectInstance)vector.elementAt(n2);
                if (!string.equals(pollingObjectInstance.getIdentifier()) || !string2.equals(pollingObjectInstance.getHostname())) {
                    return null;
                }
                vector4 = dpPollingInstance.getHistory(pollingObjectInstance.getIndex(), vector2, l);
                PollingObjectInstance pollingObjectInstance2 = new PollingObjectInstance(pollingObjectInstance.getHostname(), dpPollingDefinition.getPollingObjectDefinition().getIdentifier(), vector4, pollingObjectInstance.getIndex());
                vector3.addElement(pollingObjectInstance2);
                ++n2;
            }
        } else {
            return null;
        }
        return vector3;
    }

    public synchronized PollingObjectInstance getPollingObjectInstance(PollingObjectInstance pollingObjectInstance) throws RemoteException {
        return this.getPollingObjectInstance(pollingObjectInstance, null, 0L);
    }

    public synchronized PollingObjectInstance getPollingObjectInstance(PollingObjectInstance pollingObjectInstance, long l) throws RemoteException {
        return this.getPollingObjectInstance(pollingObjectInstance, null, l);
    }

    public synchronized PollingObjectInstance getPollingObjectInstance(PollingObjectInstance pollingObjectInstance, Vector vector, long l) throws RemoteException {
        DpPollingDefinition dpPollingDefinition;
        Vector vector2 = null;
        if (trace) {
            DpInterfaceImpl.LogMessage("Getting POI " + pollingObjectInstance.toString());
        }
        if ((dpPollingDefinition = (DpPollingDefinition)this.pollingDefinitions.get(pollingObjectInstance.getIdentifier())) == null) {
            return null;
        }
        DpPollingInstance dpPollingInstance = dpPollingDefinition.getSpecificPollingInstance(pollingObjectInstance.getHostname(), pollingObjectInstance.getIndex());
        if (dpPollingInstance == null) {
            return null;
        }
        vector2 = dpPollingInstance.getHistory(pollingObjectInstance.getIndex(), vector, l);
        PollingObjectInstance pollingObjectInstance2 = new PollingObjectInstance(pollingObjectInstance.getHostname(), dpPollingDefinition.getPollingObjectDefinition().getIdentifier(), vector2, pollingObjectInstance.getIndex());
        if (trace) {
            DpInterfaceImpl.LogMessage("\n\n\n\nRETURNING POI:\n" + pollingObjectInstance2.toString());
            DpInterfaceImpl.LogMessage("\nRETURNED POI\n");
        }
        return pollingObjectInstance2;
    }

    public synchronized Vector getPollingObjectInstanceIndices(PollingObjectInstance pollingObjectInstance) throws RemoteException {
        DpPollingInstance dpPollingInstance;
        DpPollingDefinition dpPollingDefinition;
        Vector vector = null;
        if (trace) {
            DpInterfaceImpl.LogMessage("DpInterfaceImpl:Getting POI indices " + pollingObjectInstance.toString());
        }
        if ((dpPollingDefinition = (DpPollingDefinition)this.pollingDefinitions.get(pollingObjectInstance.getIdentifier())) != null && (dpPollingInstance = dpPollingDefinition.getSpecificPollingInstance(pollingObjectInstance.getHostname(), pollingObjectInstance.getIndex())) != null) {
            vector = dpPollingInstance.getRowIds(pollingObjectInstance.getIndex());
        }
        return vector;
    }

    public synchronized boolean clearPollingObjectInstanceData(PollingObjectInstance pollingObjectInstance, long l) throws RemoteException {
        DpPollingInstance dpPollingInstance;
        boolean bl = true;
        DpPollingDefinition dpPollingDefinition = (DpPollingDefinition)this.pollingDefinitions.get(pollingObjectInstance.getIdentifier());
        bl = dpPollingDefinition != null ? ((dpPollingInstance = dpPollingDefinition.getSpecificPollingInstance(pollingObjectInstance.getHostname(), pollingObjectInstance.getIndex())) != null ? dpPollingInstance.clearHistory(pollingObjectInstance.getIndex(), l) : false) : false;
        return bl;
    }

    public boolean setDpeSchedule(Daily daily, int n) throws RemoteException {
        if (this.dpeScheduler != null) {
            this.dpeScheduler.stop();
            this.dpeScheduler = null;
        }
        this.dpeSchedule = null;
        if (daily != null) {
            if (trace) {
                DpInterfaceImpl.LogMessage("DpInterfaceImpl:setDpeSchedule - daily is:\n" + daily.toString());
            }
            this.dpeScheduler = new BasicScheduler(1, interfaceObject);
            this.dpeSchedule = daily;
            this.dpeScheduler.start();
            daily.activateSchedule(this.dpeScheduler);
            this.offAction = n;
        }
        return true;
    }

    public boolean setDpeSchedule(Weekly weekly, int n) throws RemoteException {
        if (this.dpeScheduler != null) {
            this.dpeScheduler.stop();
            this.dpeScheduler = null;
        }
        this.dpeSchedule = null;
        if (weekly != null) {
            if (trace) {
                DpInterfaceImpl.LogMessage("DpInterfaceImpl:setDpeSchedule - weekly is:\n" + weekly.toString());
            }
            this.dpeScheduler = new BasicScheduler(1, interfaceObject);
            this.dpeSchedule = weekly;
            this.dpeScheduler.start();
            weekly.activateSchedule(this.dpeScheduler);
            this.offAction = n;
        }
        return true;
    }

    public boolean setDay(int n, Daily daily) throws RemoteException {
        boolean bl = true;
        if (this.dpeSchedule instanceof Weekly) {
            try {
                ((Weekly)this.dpeSchedule).setDay(n, daily);
            }
            catch (Exception exception) {
                bl = false;
            }
        } else {
            bl = false;
        }
        return bl;
    }

    public boolean setInterval(Interval interval) throws RemoteException {
        boolean bl = true;
        if (this.dpeSchedule instanceof Daily) {
            try {
                ((Daily)this.dpeSchedule).addInterval(interval);
            }
            catch (Exception exception) {
                bl = false;
            }
        } else {
            bl = false;
        }
        return bl;
    }

    public InetAddress getHostname() throws UnknownHostException {
        return InetAddress.getLocalHost();
    }

    public String getLocalHostName() {
        return this.dpeHostname;
    }

    protected int getIntervalsMatched() {
        return intervalsMatched;
    }

    public int getPort() throws RemoteException {
        return backdoor.getPort();
    }

    public synchronized void dumpDpInterface() throws RemoteException {
        DpInterfaceImpl.LogMessage("Distributed Polling Engine state:");
        DpInterfaceImpl.LogMessage(" Tracing state : " + trace);
        DpInterfaceImpl.LogMessage(" History Size : " + historySize);
        DpInterfaceImpl.LogMessage("\n The set of Polling Definitions supported is:\n---------------------------------------------\n" + this.pollingDefinitions.toString());
        DpInterfaceImpl.LogMessage(" The list of known nodes is:\n---------------------------\n" + nodeList.toString() + "\n");
        if (healthMonitor != null) {
            DpInterfaceImpl.LogMessage(healthMonitor.getStats(false).toString());
        }
    }

    public synchronized void setHistorySize(int n) throws RemoteException {
        historySize = n;
    }

    public synchronized void setNotifyListSize(int n) throws RemoteException {
        maxNotifyListSize = n;
    }

    public synchronized void setAutoThresholdLevel(String string, String string2, NotifyObject notifyObject, float f) throws RemoteException {
        DpPollingInstance dpPollingInstance;
        DpPollingDefinition dpPollingDefinition;
        System.out.println("DpInterfaceImpl: setAutoThreshodlLevel is broken. make it work!!!!");
        if (trace) {
            DpInterfaceImpl.LogMessage("Setting auto threshold level  " + string);
        }
        if ((dpPollingDefinition = (DpPollingDefinition)this.pollingDefinitions.get(string)) != null && (dpPollingInstance = dpPollingDefinition.getSpecificPollingInstance(string2, -1L)) != null) {
            if (trace) {
                DpInterfaceImpl.LogMessage(" --> found polling instance  " + string2);
            }
            dpPollingInstance.setAutoThresholdLevel(notifyObject, f);
        }
    }

    public synchronized void shutdownDPE() throws RemoteException {
        System.exit(1);
    }

    public synchronized void setMaxConsecutiveFailures(int n) throws RemoteException {
        maxConsecutiveFailures = n;
    }

    public synchronized void toggleTrace() throws RemoteException {
        trace = !trace;
        DpInterfaceImpl.LogMessage("Trace status modified on DPE : " + trace);
    }

    public void setHistoryThreshold(float f) throws RemoteException {
        historyThreshold = f;
    }

    public void setMinTimeBetweenSaves(int n) throws RemoteException {
        minTimeBetweenSaves = n;
    }

    public void setMaxTimeBetweenSaves(int n) throws RemoteException {
        maxTimeBetweenSaves = n;
    }

    public void setValidSampleInterval(int n) throws RemoteException {
        validSampleInterval = n;
    }

    public void setDpeConfig(DpeConfig dpeConfig) throws RemoteException {
        writeToFile = dpeConfig.writeToFile;
        maxConsecutiveFailures = dpeConfig.maxConsecutiveFailures;
        historySize = dpeConfig.historySize;
        if (internalHistorySize != dpeConfig.internalHistorySize) {
            internalHistorySize = dpeConfig.internalHistorySize;
            this.changeHistorySize(historySize);
        }
        autoThresholdLevel = dpeConfig.autoThresholdLevel;
        minTimeBetweenSaves = dpeConfig.minTimeBetweenSaves;
        maxTimeBetweenSaves = dpeConfig.maxTimeBetweenSaves;
        validSampleInterval = dpeConfig.validSampleInterval;
        historyThreshold = dpeConfig.historyThreshold;
        maxNotifyListSize = dpeConfig.maxNotifyListSize;
        sendHistoryWithEvent = dpeConfig.sendHistoryWithEvent;
        useSysUpTime = dpeConfig.useSysUpTime;
        minValueVariationPercent = dpeConfig.minValueVariationPercent;
    }

    public DpeConfig getDpeConfig() throws RemoteException {
        return new DpeConfig(writeToFile, maxConsecutiveFailures, historySize, internalHistorySize, autoThresholdLevel, minTimeBetweenSaves, maxTimeBetweenSaves, validSampleInterval, historyThreshold, maxNotifyListSize, sendHistoryWithEvent);
    }

    public DpeStats getDpeStats() throws RemoteException {
        return healthMonitor.getStats(false);
    }

    protected void updateCounters(int n, int n2) {
        this.pollsSent += (long)n;
        this.variablesSent += (long)n2;
    }

    protected synchronized DpeCounters getCounters(boolean bl) {
        DpeCounters dpeCounters = null;
        dpeCounters = new DpeCounters(this.pollsSent, this.variablesSent, healthMonitor.getAveragePollingInterval(), healthMonitor.getAverageStartDelay(), healthMonitor.getAverageTotalTime(), healthMonitor.getAverageExprAndStoreTime(), healthMonitor.getAverageNumOIs(), healthMonitor.getAverageNumPDUs());
        if (bl) {
            this.pollsSent = 0L;
            this.variablesSent = 0L;
        }
        return dpeCounters;
    }

    public static boolean sendHistoryEvent(HistoryEvent historyEvent) {
        if (trace) {
            DpInterfaceImpl.LogMessage("sending normal history event------------------:\n" + historyEvent + "\n\n");
        }
        boolean bl = true;
        if (refServer != null && sendEvents) {
            try {
                refServer.historyNotify(historyEvent);
            }
            catch (RemoteException remoteException) {
                DpInterfaceImpl.LogMessage("DpInterfaceImpl : no server available to send HistoryEvent : " + historyEvent);
                bl = false;
                refServer = null;
            }
        } else {
            if (sendEvents) {
                DpInterfaceImpl.LogMessage("DpInterfaceImpl : no server available to send HistoryEvent : " + historyEvent);
            } else {
                DpInterfaceImpl.LogMessage("DpInterfaceImpl : events are turned off : " + historyEvent);
            }
            bl = false;
        }
        return bl;
    }

    public static boolean sendHistoryEvent(DpNode dpNode) {
        if (trace) {
            DpInterfaceImpl.LogMessage("sending history event with history ++++++++++++++++:\n" + dpNode + "\n\n");
        }
        boolean bl = true;
        boolean bl2 = false;
        if (refServer != null && sendEvents) {
            long l = dpNode.getLatestEntry().getDate();
            Vector vector = dpNode.getHistory(0L);
            PollingObjectInstance pollingObjectInstance = new PollingObjectInstance(dpNode.getNodeName(), dpNode.getPollingDefinition().getPollingObjectDefinition().getIdentifier(), vector);
            try {
                bl2 = refServer.historyNotify(pollingObjectInstance);
            }
            catch (RemoteException remoteException) {
                DpInterfaceImpl.LogMessage("DpInterfaceImpl : no server available to send HistoryEvent : " + remoteException);
                bl = false;
                refServer = null;
            }
            if (bl2) {
                dpNode.clearHistory(l);
            }
        } else {
            if (sendEvents) {
                DpInterfaceImpl.LogMessage("DpInterfaceImpl : no server available to send HistoryEvent ");
            } else {
                DpInterfaceImpl.LogMessage("DpInterfaceImpl : events are turned off ");
            }
            bl = false;
        }
        return bl;
    }

    public static void sendStatisticsEvent(DpeStats dpeStats) {
        if (refServer != null && sendEvents) {
            try {
                refServer.statisticsNotify(dpeStats);
                return;
            }
            catch (RemoteException remoteException) {
                DpInterfaceImpl.LogMessage("DpInterfaceImpl : no server available to send StatisticsEvent");
                refServer = null;
                return;
            }
        }
        if (sendEvents) {
            DpInterfaceImpl.LogMessage("DpInterfaceImpl : no server available to send StatisticsEvent");
        } else {
            DpInterfaceImpl.LogMessage("DpInterfaceImpl : StatisticsEvent - events are turned off");
        }
        if (dpeStats.fullInterval && trace) {
            DpInterfaceImpl.LogMessage(dpeStats.toString());
        }
    }

    public static void deleteNode(DpNode dpNode) {
        nodeList.deleteNode(dpNode);
    }

    public static void addNotification(Serializable serializable) {
        if (trace) {
            DpInterfaceImpl.LogMessage("Adding an event to the notify queue");
        }
        nList.addEvent(serializable);
    }

    public static boolean sendNotification(PerformanceEvent performanceEvent) {
        boolean bl = true;
        try {
            if (trace) {
                DpInterfaceImpl.LogMessage("Sending Threshold Notification");
            }
            if (refServer != null && sendEvents) {
                refServer.eventNotify(performanceEvent);
            } else {
                bl = false;
                if (sendEvents) {
                    DpInterfaceImpl.LogMessage("No Server avaliable - tossing 1 PerformanceEvent.");
                } else {
                    DpInterfaceImpl.LogMessage("DpInterfaceImpl:Events turned off - tossing 1 PerformanceEvent.");
                }
                refServer = null;
            }
        }
        catch (Exception exception) {
            bl = false;
            System.out.println("notification failed : " + exception + " event is:" + performanceEvent);
        }
        return bl;
    }

    public static boolean sendNotifications(Vector vector) {
        boolean bl = true;
        try {
            if (trace) {
                DpInterfaceImpl.LogMessage("Sending Threshold Notification");
            }
            if (refServer != null && sendEvents) {
                refServer.eventNotify(vector);
            } else {
                bl = false;
                if (sendEvents) {
                    System.out.println("No Server avaliable - tossing " + vector.size() + " PerformanceEvents.");
                } else {
                    System.out.println("DpInterfaceImpl:Events turned off - tossing PerformanceEvents.");
                }
                refServer = null;
            }
        }
        catch (Exception exception) {
            bl = false;
            System.out.println("notification failed : " + exception);
        }
        return bl;
    }

    public static boolean reconnect() {
        boolean bl = true;
        if (trace) {
            DpInterfaceImpl.LogMessage("DpInterfaceImpl: Reconnect attempt.");
        }
        if (refServer == null) {
            if (trace) {
                DpInterfaceImpl.LogMessage("DpInterfaceImpl: Reconnect attempt: refServer is null");
            }
            if (serverhostname != null) {
                if (trace) {
                    DpInterfaceImpl.LogMessage("DpInterfaceImpl: Reconnect attempt: serverhostname != null");
                }
                if (reconnectThreadRunning) {
                    bl = false;
                } else {
                    if (trace) {
                        DpInterfaceImpl.LogMessage("DpInterfaceImpl: Reconnect attempt: starting reconnect thread");
                    }
                    reconnectThreadRunning = true;
                    DpInterfaceImpl dpInterfaceImpl = interfaceObject;
                    dpInterfaceImpl.getClass();
                    Reconnect reconnect = dpInterfaceImpl.new Reconnect(true);
                    reconnect.start();
                    bl = false;
                }
            } else {
                if (trace) {
                    DpInterfaceImpl.LogMessage("DpInterfaceImpl: Reconnect attempt: serverhostname == null !!!!!!!!!");
                }
                bl = false;
            }
        } else if (trace) {
            DpInterfaceImpl.LogMessage("DpInterfaceImpl: Reconnect attempt: refServer is not null");
        }
        return bl;
    }

    public static boolean NodeFailure(String string) {
        return false;
    }

    public static void LogMessage(String string) {
        System.out.println(string);
    }

    private void activatePollers() {
        if (trace) {
            DpInterfaceImpl.LogMessage(" ++++  Begin activating pollers ++++ ");
        }
        Enumeration enumeration = this.pollingDefinitions.elements();
        while (enumeration.hasMoreElements()) {
            DpPollingDefinition dpPollingDefinition = (DpPollingDefinition)enumeration.nextElement();
            dpPollingDefinition.activatePollers();
        }
        if (trace) {
            DpInterfaceImpl.LogMessage(" ++++ Completed activating pollers ++++ ");
        }
    }

    private void changeHistorySize(int n) {
        Enumeration enumeration = this.pollingDefinitions.elements();
        while (enumeration.hasMoreElements()) {
            DpPollingDefinition dpPollingDefinition = (DpPollingDefinition)enumeration.nextElement();
            dpPollingDefinition.changeHistorySize(n);
        }
    }

    protected static void modifyHeartbeatTimeout(int n) {
        if (n * 2 < heartbeatTimeout) {
            heartbeatTimeout = n * 2;
        }
    }

    protected static void intervalMatched(DpNode dpNode) {
        dpNode.getSession().addMatchedInterval();
        if (intervalsMatched < 50) {
            ++intervalsMatched;
        }
        if (intervalsMatched - lastNotifiedLevel >= 10) {
            DpInterfaceImpl.sendStatisticsEvent(healthMonitor.getStats(false));
        }
    }

    protected static void intervalExceeded(DpNode dpNode, long l, long l2, long l3) {
        boolean bl = dpNode.getSession().addExceededInterval();
        intervalsMatched = !bl ? (intervalsMatched -= 5) : --intervalsMatched;
        if (intervalsMatched < -50) {
            intervalsMatched = -50;
        }
        if (lastNotifiedLevel - intervalsMatched >= 10) {
            DpInterfaceImpl.sendStatisticsEvent(healthMonitor.getStats(false));
        }
    }

    protected Vector getExceededNodes() {
        return nodeList.getExceededNodes();
    }

    public void run() {
        try {
            if (refServer != null) {
                refServer.registerDPEngine(this);
                DpInterfaceImpl.sendStatisticsEvent(this.getDpeStats());
                return;
            }
            throw new Exception();
        }
        catch (Exception exception) {
            DpInterfaceImpl.LogMessage("DpInterfaceImpl:connection to server failed:" + exception.toString());
            return;
        }
    }

    public void intervalStarted(Object object) {
        if (trace_schedule) {
            DpInterfaceImpl.LogMessage("DpInterfaceImpl: interval started for state: " + object.toString());
        }
        if (this.offAction == 1) {
            sendEvents = (Boolean)object;
            return;
        }
        if (this.offAction == 3) {
            if (trace_schedule) {
                DpInterfaceImpl.LogMessage("DpInterfaceImpl: Setting SDEVS for all nodes");
            }
            Enumeration enumeration = this.pollingDefinitions.elements();
            while (enumeration.hasMoreElements()) {
                DpPollingDefinition dpPollingDefinition = (DpPollingDefinition)enumeration.nextElement();
                dpPollingDefinition.changeInterval(object);
            }
            return;
        }
        DpInterfaceImpl.LogMessage("DpInterfaceImpl: Activating/deactivating all nodes - other action:" + this.offAction);
    }

    public void intervalEnded(Object object) {
        System.out.println("DpInterfaceImpl: interval ended for state: " + object.toString());
    }

    private static void waitForUser(String string) {
        System.out.println(string);
        try {
            System.in.read();
            while (System.in.available() > 0) {
                System.in.read();
            }
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    public static void main(String[] stringArray) {
        if (stringArray.length == 0) {
            System.out.println(" Usage: dpInterfaceImpl <serverNode> [resynch] [load] [test]");
            System.out.println("   Terminating application. Pease restart with correct parameters");
            return;
        }
        System.setSecurityManager(new RMISecurityManager());
        try {
            Object object;
            DpInterfaceImpl dpInterfaceImpl;
            boolean bl = true;
            boolean bl2 = false;
            boolean bl3 = true;
            boolean bl4 = false;
            int n = 1;
            while (n < stringArray.length) {
                if (stringArray[n].equals("noresynch")) {
                    bl = false;
                } else if (stringArray[n].equals("load")) {
                    bl2 = true;
                } else if (stringArray[n].equals("nofile")) {
                    bl3 = false;
                } else if (stringArray[n].equals("test")) {
                    bl4 = true;
                }
                ++n;
            }
            DpInterfaceImpl dpInterfaceImpl2 = dpInterfaceImpl = new DpInterfaceImpl(stringArray[0], "test_data", bl, bl2, bl3);
            if (!bl4 && refServer == null) {
                reconnectThreadRunning = true;
                DpInterfaceImpl dpInterfaceImpl3 = dpInterfaceImpl;
                dpInterfaceImpl3.getClass();
                object = dpInterfaceImpl3.new Reconnect(true);
                ((Thread)object).start();
            }
            if (bl4) {
                String[] stringArray2;
                int n2;
                Hashtable<String, String> hashtable;
                Object object2;
                long l = 1L;
                test = true;
                System.out.println(dpInterfaceImpl2.getHostname().toString());
                NotifyObject notifyObject = new NotifyObject("AUTO", 0.0f, null, 0.0f, 30);
                NotifyObject notifyObject2 = new NotifyObject(">", 10.0f, "<", 6.0f, 3);
                NotifyObject notifyObject3 = new NotifyObject("AUTO", 0.0f, "<", 0.0f, 3);
                System.out.println(notifyObject.getIdentifier());
                if (notifyObject.equals(notifyObject)) {
                    System.out.println("n=n");
                } else {
                    System.out.println("n!=n!!!!!");
                }
                if (notifyObject.equals(notifyObject2)) {
                    System.out.println("n=n2!!!!!!");
                } else {
                    System.out.println("n!=n2");
                }
                if (notifyObject.equals(notifyObject3)) {
                    System.out.println("n=n3!!!!!!");
                } else {
                    System.out.println("n!=n3");
                }
                new PollingObjectDefinition("snmpOutPkts", 1, "1.3.6.1.2.1.11.2.0", "3", notifyObject);
                new PollingObjectDefinition("snmpInPkts", 1, "r 1.3.6.1.2.1.11.1.0", "3", notifyObject);
                new PollingObjectDefinition("rate", 1, "(((r 1.3.6.1.2.1.10.5.5.1.6.* * 8)/(1.3.6.1.2.1.2.2.1.5.$1))* 100)", "3", notifyObject);
                new PollingObjectDefinition("fred", 1, "r 1.3.6.1.2.1.2.2.1.[pktType].[interface]", "3", notifyObject);
                PollingObjectDefinition pollingObjectDefinition = new PollingObjectDefinition("goodInput", 1, "(r 1.3.6.1.2.1.2.2.1.11.* + r 1.3.6.1.2.1.2.2.1.12.*)", "3", notifyObject);
                dpInterfaceImpl2.addPollingObjectDefinition(pollingObjectDefinition);
                Vector<String> vector = new Vector<String>();
                Vector<String> vector2 = new Vector<String>();
                Vector<PollingObjectInstance> vector3 = new Vector<PollingObjectInstance>();
                if (!bl2) {
                    object2 = "public";
                    hashtable = "goodInput";
                    vector3.addElement(new PollingObjectInstance("9.67.214.115", (String)object2, (String)((Object)hashtable), l++));
                    vector2.addElement(new String("rate"));
                } else {
                    object2 = new NotifyObject(2, 120);
                    vector.addElement(new String(stringArray[0]));
                    n2 = 0;
                    while (n2 < 100) {
                        hashtable = new PollingObjectDefinition("misc" + n2, 1, "1.3.6.1.2.1.11.1.0, 1.3.6.1.2.1.11.2.0", "3", (NotifyObject)object2);
                        dpInterfaceImpl2.addPollingObjectDefinition((PollingObjectDefinition)((Object)hashtable));
                        vector2.addElement(new String("misc" + n2));
                        ++n2;
                    }
                }
                trace_expression = true;
                System.out.println(dpInterfaceImpl.getLocalHostName());
                DpInterfaceImpl.waitForUser("$$$$  Waiting to get config     $$$$$$$");
                object2 = dpInterfaceImpl2.getDpeConfig();
                System.out.println(object2);
                ((DpeConfig)object2).historySize = 100;
                ((DpeConfig)object2).internalHistorySize = 10;
                ((DpeConfig)object2).maxTimeBetweenSaves = 300;
                ((DpeConfig)object2).historyThreshold = 1.0f;
                dpInterfaceImpl2.setDpeConfig((DpeConfig)object2);
                object2 = dpInterfaceImpl2.getDpeConfig();
                System.out.println(object2);
                System.out.println(healthMonitor.getStats(false).toString());
                DpInterfaceImpl.waitForUser("$$$$  Waiting to start adding poi    $$$$$$$");
                System.currentTimeMillis();
                dpInterfaceImpl2.toggleTrace();
                hashtable = new Hashtable<String, String>();
                hashtable.put("pktType", "10");
                hashtable.put("interface", "0");
                n2 = 0;
                while (n2 < vector3.size()) {
                    stringArray2 = (String[])vector3.elementAt(n2);
                    stringArray2.setKeywords(hashtable);
                    ++n2;
                }
                System.out.println("adding poi returned " + dpInterfaceImpl2.addPollingObjectInstances(vector3));
                System.out.println("running " + vector3.size() + " instances.");
                DpInterfaceImpl.waitForUser("$$$$  Waiting to set schedule     $$$$$$$");
                stringArray2 = TimeZone.getAvailableIDs(0);
                SimpleTimeZone simpleTimeZone = new SimpleTimeZone(0, stringArray2[0]);
                GregorianCalendar gregorianCalendar = new GregorianCalendar(simpleTimeZone);
                int n3 = gregorianCalendar.get(11);
                String string = "Goofy";
                String string2 = "Donald";
                Daily daily = new Daily("Normal");
                int n4 = n3 - 1;
                while (n4 < n3 + 2) {
                    int n5 = 0;
                    while (n5 <= 59) {
                        daily.addInterval(new Interval(string, n4, n5, n4, n5 + 3));
                        daily.addInterval(new Interval(string2, n4, n5 + 5, n4, n5 + 7));
                        n5 += 10;
                    }
                    ++n4;
                }
                System.out.println("Setting schedlue to :\n" + daily.toString());
                dpInterfaceImpl2.setDpeSchedule(daily, 3);
                DpInterfaceImpl.waitForUser("$$$$  Waiting to get poi     $$$$$$$");
                long l2 = System.currentTimeMillis();
                object = dpInterfaceImpl2.getPollingObjectInstance((PollingObjectInstance)vector3.elementAt(0));
                System.out.println("(1) : " + ((PollingObjectInstance)object).toString());
                long l3 = System.currentTimeMillis();
                object = dpInterfaceImpl2.getPollingObjectInstance((PollingObjectInstance)vector3.elementAt(0), l3);
                System.out.println("(2) : " + new Date(l3) + ((PollingObjectInstance)object).toString());
                object = dpInterfaceImpl2.getPollingObjectInstance((PollingObjectInstance)vector3.elementAt(0), l3 - 10000L);
                System.out.println("(3) : " + new Date(l3 - 10000L) + ((PollingObjectInstance)object).toString());
                dpInterfaceImpl2.clearPollingObjectInstanceData((PollingObjectInstance)vector3.elementAt(0), l3);
                object = dpInterfaceImpl2.getPollingObjectInstance((PollingObjectInstance)vector3.elementAt(0));
                System.out.println("(4) : " + new Date(l3) + "   " + ((PollingObjectInstance)object).toString());
                l3 = System.currentTimeMillis();
                System.out.println(l3 - l2);
                System.out.println(System.currentTimeMillis() - l3);
                System.out.println("$$$$  Waiting to add NO to poller instances     $$$$$$$");
                System.in.read();
                while (System.in.available() > 0) {
                    System.in.read();
                }
                System.out.println("$$$$$   Waiting to remove NO $$$$$$$$$$$");
                System.in.read();
                while (System.in.available() > 0) {
                    System.in.read();
                }
                dpInterfaceImpl2.dumpDpInterface();
                System.in.read();
                System.out.println("$$$$$$  Waiting to remove all POI   $$$$");
                while (System.in.available() > 0) {
                    System.in.read();
                }
                dpInterfaceImpl2.removePollingObjectInstances(vector3);
                System.out.println("removed a pollingInstance????");
                System.in.read();
                System.out.println("$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$");
                dpInterfaceImpl2.dumpDpInterface();
                System.exit(0);
                return;
            }
        }
        catch (Exception exception) {
            System.out.println("DpInterfaceImpl.main: an exception occurred:");
            exception.printStackTrace();
            return;
        }
    }

    static {
        nList = new NotifyList();
        dataRoot = new String("data");
        writeToFile = true;
        maxConsecutiveFailures = 25;
        historySize = 3600;
        internalHistorySize = 60;
        autoThresholdLevel = 1.4f;
        minTimeBetweenSaves = 30;
        maxTimeBetweenSaves = 1200;
        validSampleInterval = 600;
        historyThreshold = 0.8f;
        maxNotifyListSize = 100;
        heartbeatTimeout = 60000;
        fileBase = "data";
        intervalsMatched = 50;
        timeDelayAfterReconnect = 5000;
        lastNotifiedLevel = 50;
        minValueVariationPercent = 0.05f;
        sendEvents = true;
    }

    class Reconnect
    extends Thread {
        private boolean retry = false;

        public Reconnect(boolean bl) {
            DpInterfaceImpl.this = DpInterfaceImpl.this;
            this.retry = bl;
        }

        public void run() {
            while (true) {
                try {
                    DpInterfaceImpl.LogMessage("DpInterfaceImpl:Trying to reconnect to server:" + serverhostname);
                    refServer = (DpmInterface)Naming.lookup("rmi://" + serverhostname + ":2099/dpServer");
                    refServer.registerDPEngine(interfaceObject);
                    DpInterfaceImpl.sendStatisticsEvent(DpInterfaceImpl.this.getDpeStats());
                    timeDelayAfterReconnect = 5000;
                    DpInterfaceImpl.LogMessage("DpInterfaceImpl:Reconnected to Server:" + serverhostname);
                }
                catch (Exception exception) {
                    DpInterfaceImpl.LogMessage("DpInterfaceImpl:looping in reconnect. Error was: " + exception.toString());
                    Reconnect reconnect = this;
                    synchronized (reconnect) {
                        try {
                            DpInterfaceImpl.LogMessage("DpInterfaceImpl:looping in reconnect. waiting for " + timeDelayAfterReconnect);
                            Thread.sleep(timeDelayAfterReconnect);
                        }
                        catch (Exception exception2) {}
                        if (timeDelayAfterReconnect < 60000) {
                            timeDelayAfterReconnect += 2000;
                        }
                        continue;
                    }
                    if (this.retry) continue;
                }
                break;
            }
            if (trace) {
                DpInterfaceImpl.LogMessage("DpInterfaceImpl:finished looping in reconnect.");
            }
            reconnectThreadRunning = false;
        }
    }
}

